
int buttonPin = 2;    // Bouton-poussoir - broche 2
int ledPin = 8;       // LED - broche 8
int ledState;        // État de la LED

int buttonStateActual;    // Enregistre l'état actuel du bouton-poussoir
int prevbuttonState;      // Enregistre l'état précédent du bouton-poussoir
int debouncedButtonState; // Enregistre l'état lissé du bouton-poussoir
int debounceInterval = 10;     // Intervalle de 10ms
unsigned long lastDebounceTime = 0; // Période ans changement d'état de la LED

void setup( ) {
  pinMode(ledPin, OUTPUT);   // Broche de la LED comme sortie
  pinMode(buttonPin, INPUT); // Broche du bouton poussoir comme sortie
}

void loop() {
  buttonStateActual = digitalRead(buttonPin);  // Lit l'état du bouton
  unsigned long currentTime = millis();        // Lit la période de lissage
  
  if(buttonStateActual != prevbuttonState) lastDebounceTime = currentTime;
  if (currentTime - lastDebounceTime > debounceInterval){
    if (buttonStateActual != debouncedButtonState){
      debouncedButtonState = buttonStateActual;
      // Changement du niveau de la LED quand l'état du bouton - niveai HIGH
      if (debouncedButtonState == HIGH) ledState = !ledState;
    }
  }
  digitalWrite(ledPin, ledState);       // Commande la LED
  prevbuttonState = buttonStateActual;  // Enregistre l'état précédent du bouton-poussoir
}
